/**
* \file: NaviStatus.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: Ajay Kumar Sahoo/ RBEI/ECF3 / ajaykumar.sahoo@in.bosch.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_NAVISTATUS_H
#define AAUTO_NAVISTATUS_H

#include <string>
#include <aauto/AditNavigationStatus.h>

namespace adit { namespace aauto {

class NaviStatusImpl;

class NaviStatus : public AditNavigationStatus
{
public:
    NaviStatus(uint8_t inSessionId, MessageRouter* inMessageRouter, int inMinIntervalMs, int inheight, int inWidth,
                   int inColorDepthBits, NavigationStatusService_InstrumentClusterType inType);

    ~NaviStatus();

    /**
     * @brief Set configuration for platform and AAuto-related items.
     *         All configurations must be called before init().
     * @param  inKey        The key string for configuration
     * @param  inValue      The actual value for configuration */
    void setConfigItem(std::string inKey, std::string inValue);

    /**
     * @brief Register callbacks to receive media playback status notifications.
     * @param   inCallbacks object implementing the callback interface */
    void registerCallbacks(IAditNavigationStatusCallbacks* inCallbacks);

    /**
     * @brief Initialize the endpoints.
     *      All configuration items must be set before calling this function.
     * @return true if initialization succeeds.
     *      false if fails. */
    bool init();

    /**
     * @brief  Shut down the endpoint and release allocated resources */
    void shutdown();

private:
    NaviStatusImpl* impl;
};


} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_NAVISTATUS_H */

